<?php

namespace GFPDF\Helper\Fields;

use GFPDF\Helper\Helper_Abstract_Fields;
use GFPDF\Helper\Helper_Abstract_Form;
use GFPDF\Helper\Helper_Misc;
use ImageHopper\ImageHopper\Fields\ImageHopperPostField;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 *
 * @package GFPDF\Helper\Fields
 *
 * @since   2.11
 */
class Field_Image_Hopper_Post extends Field_Post_Image {

	/**
	 * Check the appropriate variables are parsed in send to the parent construct
	 *
	 * @param object               $field The GF_Field_* Object
	 * @param array                $entry The Gravity Forms Entry
	 *
	 * @param Helper_Abstract_Form $gform
	 * @param Helper_Misc          $misc
	 *
	 * @throws Exception
	 *
	 * @since 2.11
	 */
	public function __construct( $field, $entry, Helper_Abstract_Form $gform, Helper_Misc $misc ) {

		if ( ! is_object( $field ) || ! $field instanceof ImageHopperPostField ) {
			throw new Exception( '$field needs to be in instance of ImageHopperPostField' );
		}

		/* call our parent method */
		Helper_Abstract_Fields::__construct( $field, $entry, $gform, $misc );
	}

	/**
	 * Output full-size image in PDF, instead of scaled down version
	 *
	 * @param $value
	 * @param $label
	 *
	 * @return string
	 *
	 * @since 2.11
	 */
	public function html( $value = '', $label = true ) {
		$value = $this->value();

		$html = '';
		if ( ! empty( $value['url'] ) ) {
			$html = sprintf(
				'<a href="%s" target="_blank">',
				esc_url( isset( $value['secured_url'] ) ? $value['secured_url'] : $value['url'] )
			);

			$html .= sprintf(
				'<img src="%s" style="max-height:100%%" />',
				$value['path'] !== $value['url'] ? esc_attr( $value['path'] ) : esc_url( $value['url'] )
			);

			$html .= '</a>';
		}

		/* Include title / caption / description if needed */
		if ( ! empty( $value['title'] ) ) {
			$html .= '<div class="gfpdf-post-image-title">' . esc_html( $value['title'] ) . '</div>';
		}

		if ( ! empty( $value['caption'] ) ) {
			$html .= '<div class="gfpdf-post-image-caption">' . esc_html( $value['caption'] ) . '</div>';
		}

		if ( ! empty( $value['description'] ) ) {
			$html .= '<div class="gfpdf-post-image-description">' . esc_html( $value['description'] ) . '</div>';
		}

		return Helper_Abstract_Fields::html( $html );
	}
}


