<?php

namespace ImageHopper\ImageHopper\ThirdParty\GravityKit;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * @since 2.13.6
 */
class GravityImport {

	private static $_instance = null;

	/**
	 * Returns an instance of this class, and stores it in the $_instance property.
	 *
	 * @return self $_instance An instance of this class.
	 *
	 * @since 2.13.6
	 */
	public static function get_instance() {
		if ( self::$_instance === null ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	/**
	 * @since 2.13.6
	 */
	public function init() {
		add_filter( 'image_hopper_field_input_type', [ $this, 'is_entry_import' ] );
	}

	/**
	 * Check if the GravityKit Import Entry functionality is running
	 *
	 * @return bool
	 *
	 * @since 2.13.6
	 */
	public function is_entry_import( $type ) {
		if (
			defined( 'REST_REQUEST' ) && REST_REQUEST &&
			( strpos( $GLOBALS['wp']->query_vars['rest_route'], '/gravityview/import/' ) !== false )
		) {
			return 'fileupload';
		}

		return $type;
	}

}
