<?php

namespace ImageHopper\ImageHopper\Helpers;

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

/**
 * Class ArrayHelper
 *
 * @package ImageHopper\ImageHopper\Helpers
 *
 * @since 1.1.0
 */
class ArrayHelper {

	/**
	 * Inserts new element(s) into array after current $key
	 *
	 * @param array $array
	 * @param string $key
	 * @param array $array_to_insert
	 *
	 * @return array
	 *
	 * @since 1.1.0
	 */
	public static function insert_after( $array, $key, $array_to_insert ) {
		$key_pos = array_search( $key, array_keys( $array ), true );
		if ( $key_pos !== false ) {
			$key_pos++;
			$second_array = array_splice( $array, $key_pos );
			$array        = array_merge( $array, $array_to_insert, $second_array );
		}

		return $array;
	}
}
