import $ from 'jquery'

/**
 * @package     Image Hopper
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://opensource.org/licenses/gpl-3.0.php GNU Public License
 */

export function getEntryId (element) {
  const $form = $(element).parents('form')
  let entryId = $form.find('#entry_id').val()

  // test for GravityView support
  if (entryId === undefined || entryId.length === 0) {
    entryId = $form.find('input[name="lid"]').val()
  }

  // test for Gravity Flow support
  if ((entryId === undefined || entryId.length === 0) && $form.find('input[name="step_id"]').length > 0) {
    entryId = $form.attr('action').split('lid=')[1]
  }

  // test for Nested Forms
  if (entryId === undefined || entryId.length === 0) {
    entryId = $form.find('input[name="gpnf_entry_id"]').val()
  }

  return entryId
}
