/* eslint-disable */

function SetDefaultValues_image_hopper_post (field) {
  field.label = '%1$s'
}

function ToggleMinimumImageSize (checked) {
  const $element = jQuery('#input_minimum_dimensions')

  if (!checked) {
    SetFieldProperty('inputMinImageSizeWidth', '')
    SetFieldProperty('inputMinImageSizeHeight', '')
    jQuery('#input_minimum_width').val('')
    jQuery('#input_minimum_height').val('')
  }

  checked ? $element.show() : $element.hide()
}

function ToggleMinimumImageSizeWarning (checked) {
  const $element = jQuery('#input_minimum_warning_dimensions')

  if (!checked) {
    SetFieldProperty('inputMinImageSizeWarningWidth', '')
    SetFieldProperty('inputMinImageSizeWarningHeight', '')
    jQuery('#input_minimum_warning_width').val('')
    jQuery('#input_minimum_warning_height').val('')
  }

  checked ? $element.show() : $element.hide()
}

function ToggleUpscaleImage (checked) {
  const $upscaleImageSection = jQuery('li[class^="image_hopper_upscale_field"]')

  checked ? $upscaleImageSection.show() : $upscaleImageSection.hide()
}

jQuery(document).bind('gform_load_field_settings', function (event, field, form) {
  if (field.type === 'image_hopper_post') {
    jQuery('#input_maximum_width').val(field.inputWidth)
    jQuery('#input_maximum_height').val(field.inputHeight)
    jQuery('#input_class_setting').val(field.inputClass)
    jQuery('#input_output_quality').val(field.outputQuality)

    // Minimum Image Sizes
    jQuery('#input_minimum_image_size').prop('checked', field.inputMinImageSize === true)
    jQuery('#input_minimum_image_size_warning').prop('checked', field.inputMinImageSizeWarning === true)

    ToggleMinimumImageSize(field.inputMinImageSize)
    ToggleMinimumImageSizeWarning(field.inputMinImageSizeWarning)

    jQuery('#input_minimum_width').val(field.inputMinImageSizeWidth)
    jQuery('#input_minimum_height').val(field.inputMinImageSizeHeight)
    jQuery('#input_minimum_warning_width').val(field.inputMinImageSizeWarningWidth)
    jQuery('#input_minimum_warning_height').val(field.inputMinImageSizeWarningHeight)
    jQuery('#input_rename_imagehopper_files').val(field.inputRenameImageHopperFiles)

    // Crop to Size
    jQuery('#input_enable_crop_to_size').prop('checked', field.cropToSize === true)

    // Upscale
    jQuery('#editor_enable_upscale_image').prop('checked', field.upscaleImageToCropSize === true)
    ToggleUpscaleImage(field.cropToSize)

    gform.doAction('image_hopper_load_field_settings', field, form)
  }

  /* Add Fileupload / Image Hopper Conversion */
  if (field.type === 'post_image' && jQuery('#gfield_ih_convert_' + field.id).length === 0) {
    // Add new button to transform it into a Post Image Hopper field
    jQuery('<button id="gfield_ih_convert_' + field.id + '" class="gfield-field-action gfield-edit gfield-convert" onClick="ImageHopperConvertFieldPost(field, \'image_hopper_post\');" onKeyPress="ImageHopperConvertFieldPost(field, \'image_hopper_post\'); return false;" aria-label="%4$s"><i class="gform-icon gform-icon--post-image" style="font-size: 1.625rem;" ></i><span class="gfield-field-action__description" aria-hidden="true">%3$s</span> </button>')
      .insertAfter('#gfield_edit_' + field.id)
  }

  if (field.type === 'image_hopper_post' && jQuery('#gfield_ih_convert_' + field.id).length === 0) {
    // Add new button to transform it into a Post Image field
    jQuery('<button id="gfield_ih_convert_' + field.id + '" class="gfield-field-action gfield-edit gfield-convert" onClick="ImageHopperConvertFieldPost(field, \'post_image\');" onKeyPress="ImageHopperConvertFieldPost(field, \'post_image\'); return false;" aria-label="%4$s"><i class="gform-icon gform-icon--consent" style="font-size: 1.625rem;" ></i><span class="gfield-field-action__description" aria-hidden="true">%3$s</span> </button>')
      .insertAfter('#gfield_edit_' + field.id)
  }
})

function ImageHopperConvertFieldPost (field, convertTo) {
  switch (convertTo) {
    case 'post_image':
      SetFieldProperty('type', 'post_image')
      SetFieldProperty('allowedExtensions', 'jpg, jpeg, png, gif')
      SetFieldProperty( 'multipleFiles', false)
      StartChangeInputType('post_image', field)
      break

    case 'image_hopper_post':
      SetFieldProperty('type', 'image_hopper_post')
      SetFieldProperty('allowedExtensions', '%2$s')
      SetFieldProperty('multipleFiles', true)
      SetFieldProperty('maxFiles', 1)
      StartChangeInputType('image_hopper_post', field)
      break
  }
}