/**
 * @package     Image Hopper Editor
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://imagehopper.tech/commercial-license/ Commercial License
 */

export default function getFinetuneControlConfig (pluginFinetuneDefaults, enabledFeatures) {
  const finetuneProperties = [
    'brightness',
    'contrast',
    'saturation',
    'exposure',
    'temperature',
    'gamma',
    'clarity',
    'vignette'
  ]
  let activeFinetuneProperties = enabledFeatures.field_color ? finetuneProperties.filter(a => enabledFeatures['field_' + a] === true) : []

  // Backwards compatibility for when field_color did not have any sub keys
  activeFinetuneProperties = enabledFeatures.field_color && activeFinetuneProperties.length > 0 ? activeFinetuneProperties : finetuneProperties

  // Get the finetune control configuration
  const finetuneControlConfiguration = {}

  activeFinetuneProperties.forEach(name => {
    finetuneControlConfiguration[name] = pluginFinetuneDefaults.finetuneControlConfiguration[name]
  })

  return finetuneControlConfiguration
}
