import {
  createMarkupEditorToolbar
} from '@pqina/pintura'

/**
 * @package     Image Hopper Editor
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://imagehopper.tech/commercial-license/ Commercial License
 */

export function getAnnotateProperties (enabledFeatures) {

  const annotateProperties = {
    sharpie: enabledFeatures.field_draw,
    line: enabledFeatures.field_arrow,
    path: enabledFeatures.field_path,
    arrow: enabledFeatures.field_arrow,
    text: enabledFeatures.field_text,
    rectangle: enabledFeatures.field_square,
    ellipse: enabledFeatures.field_circle,
  }

  const activeAnnotateProperties = []

  Object.entries(annotateProperties).forEach(([type, active]) => {
    if (active) {
      activeAnnotateProperties.push(type)
    }
  })

  return createMarkupEditorToolbar(activeAnnotateProperties)
}

export function getActiveAnnotateTool(tool) {
  const annotateProperties = {
    field_draw: 'sharpie',
    field_line: 'line',
    field_path: 'path',
    field_arrow: 'arrow',
    field_text: 'text',
    field_square: 'rectangle',
    field_circle: 'ellipse'
  }

  return annotateProperties[tool] ?? 'sharpie'
}
