import { plugin_filter_defaults } from '@pqina/pintura'

/**
 * @package     Image Hopper Editor
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://imagehopper.tech/commercial-license/ Commercial License
 */

export default function filterOptions (filterProperties) {
  const list = plugin_filter_defaults.filterOptions

  const activeList = [
    list[0],
    ['Classic', []],
    ['Monochrome', []],
    ['Sepia', []]
  ]

  // Check if filter feature is checked
  if (filterProperties.filter) {
    list.forEach((group, index) => {
      group[1].forEach(item => {
        if (filterProperties[item[0]]) {
          activeList[index][1].push(item)
        }
      })
    })
  }

  return activeList
}
