import { plugin_filter_defaults } from '@pqina/pintura'

/**
 * @package     Image Hopper Editor
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     https://imagehopper.tech/commercial-license/ Commercial License
 */

export default function defaultFilterMatrix (defaultFilter) {
  switch (defaultFilter) {
    case 'field_pastel': return plugin_filter_defaults.filterFunctions.pastel()
    case 'field_chrome': return plugin_filter_defaults.filterFunctions.chrome()
    case 'field_fade': return plugin_filter_defaults.filterFunctions.fade()
    case 'field_warm': return plugin_filter_defaults.filterFunctions.warm()
    case 'field_cold': return plugin_filter_defaults.filterFunctions.cold()
    case 'field_mono': return plugin_filter_defaults.filterFunctions.monoDefault()
    case 'field_mono_noir': return plugin_filter_defaults.filterFunctions.monoNoir()
    case 'field_mono_wash': return plugin_filter_defaults.filterFunctions.monoWash()
    case 'field_mono_stark': return plugin_filter_defaults.filterFunctions.monoStark()
    case 'field_sepia': return plugin_filter_defaults.filterFunctions.sepiaDefault()
    case 'field_sepia_blues': return plugin_filter_defaults.filterFunctions.sepiaBlues()
    case 'field_sepia_rust': return plugin_filter_defaults.filterFunctions.sepiaRust()
    case 'field_sepia_color': return plugin_filter_defaults.filterFunctions.sepiaColor()
    default: return false
  }
}
