<?php
/**
 * Plugin Name:     Image Hopper Editor
 * Plugin URI:      https://imagehopper.tech
 * Description:     Turns Image Hopper into the Ultimate Gravity Forms Image Editor
 * Author:          Image Hopper
 * Author URI:      https://imagehopper.tech
 * Update URI:      https://imagehopper.tech
 * Text Domain:     image-hopper-editor
 * Domain Path:     /languages
 * Version:         2.11.5
 * Requires WP:     5.2
 * Requires PHP:    5.6
 */

/**
 * @package     Image Hopper Editor
 * @copyright   Copyright (c) 2025, Image Hopper
 * @license     http://opensource.org/licenses/gpl-2.0.php GNU Public License
 */

define( 'IMAGE_HOPPER_EDITOR_ADDON_VERSION', '2.11.5' );
define( 'IMAGE_HOPPER_EDITOR_ADDON_FILE', __FILE__ );

/* When Gravity Forms loads, we'll load */
add_action( 'gform_loaded', [ 'Image_Hopper_Editor_Gravity_Forms_AddOn_Bootstrap', 'load' ], 6 );

/**
 * Class Image_Hopper_Editor_Gravity_Forms_AddOn_Bootstrap
 *
 * @since 1.0.0
 */
class Image_Hopper_Editor_Gravity_Forms_AddOn_Bootstrap {

	/**
	 * @since 1.0.0
	 */
	public static function load() {

		/* Stop loading if Image Hopper isn't active */
		if ( ! class_exists( 'Image_Hopper_Gravity_Forms_AddOn_Bootstrap' ) ) {
			return;
		}

		require_once __DIR__ . '/src/Editor.php';

		$editor = \ImageHopper\ImageHopperEditor\Editor::get_instance();

		add_action( 'init', [ $editor, 'init' ] );
		add_action( 'admin_init', [ $editor, 'init_admin' ] );

		/* Add translation support */
		load_plugin_textdomain( 'image-hopper-editor', false, basename( dirname( __FILE__ ) ) . '/languages/' );
	}

}
