<?php

namespace GiveStripe\Settings\Facades;

/**
 * @since 2.6.0
 */
class StripeApiKeysFacade
{
    /**
     * @since 2.6.0
     */
    public function isRestrictedKey(string $apiKey): bool
    {
        $keyPrefix = explode('_', $apiKey)[0];

        return 'rk' === $keyPrefix;
    }

    /**
     * @since 2.6.0
     */
    public function isSecretKey(string $apiKey): bool
    {
        $keyPrefix = explode('_', $apiKey)[0];

        return 'sk' === $keyPrefix;
    }

    /**
     * @since 2.6.0
     */
    public function hasManualIntegrationsUsingSecretKeys(): bool
    {
        $accounts = give_get_option('_give_stripe_get_all_accounts');

        foreach ($accounts as $account) {
            if ('manual' == $account['type'] && ($this->isSecretKey($account['live_secret_key']) || $this->isSecretKey($account['test_secret_key']))) {
                return true;
            }
        }

        return false;
    }
}
