<?php

namespace GiveStripe\Settings\Admin;

/**
 * @since 2.7.0
 */
class PremiumSettings
{
    /**
     * @since 2.7.0
     */
    public function __invoke($settings): array
    {
        return $this->addSettings($settings);
    }

    /**
     * @since 2.7.0
     */
    private function addSettings($settings): array
    {
        $settings['general'][] = [
            'name'    => esc_html__('Stripe Subscription Pause', 'give'),
            'desc'    => esc_html__(
                'Enable this option if you would like to allow donors the ability to pause their subscription from the Donor Dashboard.',
                'give'
            ),
            'id'      => 'stripe_subscription_pause',
            'type'    => 'radio_inline',
            'default' => 'enabled',
            'options' => [
                'enabled'  => esc_html__('Enabled', 'give'),
                'disabled' => esc_html__('Disabled', 'give'),
            ],
        ];

        return $settings;
    }
}
