<?php

namespace GiveStripe\Settings\Admin;

use GiveStripe\Settings\Facades\StripeApiKeys;

/**
 * @since 2.6.0
 */
class Notices
{
    /**
     * @since 2.6.0
     */
    public function migrateToRestrictedKeysWarning()
    {
        if ( ! StripeApiKeys::hasManualIntegrationsUsingSecretKeys()) {
            return;
        }

        $notice = [
            'id' => 'give-stripe-migrate-to-restricted-keys-warning',
            'type' => 'warning',
            'description' => sprintf(
                __('A Stripe connection was found using secret API Keys. Due to recent changes in Stripe, we strongly encourage you to <a href="%s" target="_blank">install our GiveWP Stripe App</a> and update your integration in the <a href="%s" >settings page</a> to use Restricted API keys (RAK). <a href="%s" target="_blank">View GiveWP Stripe add-on setup steps &raquo;</a>',
                    'give-stripe'),
                'https://marketplace.stripe.com/apps/givewp',
                admin_url('/edit.php?post_type=give_forms&page=give-settings&tab=gateways&section=stripe-settings'),
                'https://givewp.com/documentation/add-ons/stripe-gateway/'
            ),
        ];

        Give()->notices->register_notice($notice);
    }
}
