<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * Class UpdateSubscriptionStatus
 *
 * This class uses as request to get a product.
 *
 * @since 2.6.0
 */
class UpdateSubscriptionStatus extends HttpRequest
{
    /**
     * CreatePlan constructor.
     *
     * @since 2.6.0
     */
    public function __construct(array $headers, string $paypalSubscriptionId, string $subscriptionStatus)
    {
        $endpoint = sprintf(
            '/v1/billing/subscriptions/%1$s/%2$s',
            $paypalSubscriptionId,
            $subscriptionStatus
        );

        parent::__construct($endpoint, 'POST');

        $this->headers = array_merge($this->headers, $headers);
    }
}
