<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * Class CreatePlan
 *
 * This class uses as request to create a plan.
 *
 * @since 2.6.0
 */
class CreatePlan extends HttpRequest
{
    /**
     * CreatePlan constructor.
     *
     * @since 2.6.0
     */
    public function __construct(array $headers, array $requestBody)
    {
        parent::__construct('/v1/billing/plans', 'POST');

        $this->headers = array_merge($this->headers, $headers);
        $this->body = wp_json_encode($requestBody);
    }
}
