<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Razorpay\Webhooks;

use Give\Framework\Support\Facades\ActionScheduler\AsBackgroundJobs;

/**
 * @since 2.9.0
 */
class RazorpaySubscriptionWebhookNotificationHandler
{
    /**
     * @since 2.9.0
     *
     * @see https://razorpay.com/docs/webhooks/payloads/subscriptions/
     */
    public function __invoke($webhookNotification)
    {
        switch ($webhookNotification->event) {
            /** @see https://razorpay.com/docs/webhooks/payloads/subscriptions/#subscription-cancelled */
            case 'subscription.cancelled':
                $razorpaySubscriptionId = $webhookNotification->payload->subscription->entity->id;
                $this->setSubscriptionCancelledAsyncEvent($razorpaySubscriptionId);
                break;
            /** @see https://razorpay.com/docs/webhooks/payloads/invoices/#invoice-paid */
            case 'invoice.paid':
                $razorpayPaymentId = $webhookNotification->payload->invoice->entity->payment_id;
                if ( ! give()->donations->getByGatewayTransactionId($razorpayPaymentId)) {
                    $razorpaySubscriptionId = $webhookNotification->payload->invoice->entity->subscription_id;
                    $this->setSubscriptionRenewalPaymentAsyncEvent($razorpaySubscriptionId, $razorpayPaymentId);
                }
                break;
        }
    }

    /**
     * @since 2.9.0
     */
    public function setSubscriptionRenewalPaymentAsyncEvent(
        string $gatewaySubscriptionId,
        string $gatewayTransactionId
    ) {
        $this->enqueueAsyncAction('givewp_razorpay_event_subscription_renewal_donation',
            [$gatewaySubscriptionId, $gatewayTransactionId]);
    }

    /**
     * @since 2.9.0
     */
    private function setSubscriptionCancelledAsyncEvent(string $gatewaySubscriptionId)
    {
        $this->enqueueAsyncAction('givewp_razorpay_event_subscription_cancelled', [$gatewaySubscriptionId]);
    }

    /**
     * @since 2.9.0
     */
    private function enqueueAsyncAction(string $hook, array $args)
    {
        AsBackgroundJobs::enqueueAsyncAction($hook, $args, 'give-recurring-razorpay');
    }
}
