<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\PayPalCommerce;

use Exception;
use Give\Donations\Models\Donation;
use Give\Framework\PaymentGateways\Commands\GatewayCommand;
use Give\Framework\PaymentGateways\Commands\SubscriptionProcessing;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Framework\PaymentGateways\SubscriptionModule;
use Give\Subscriptions\Models\Subscription;
use Give\Subscriptions\ValueObjects\SubscriptionStatus;
use GiveRecurring\PaymentGateways\PayPalCommerce\Repositories\Subscription as SubscriptionRepository;

/**
 * @since 2.5.0
 */
class PayPalCommerceSubscriptionModule extends SubscriptionModule
{
    /**
     * @since 2.12.0 updated to support activating subscriptions
     * @since 2.5.0
     * @throws Exception
     */
    public function createSubscription(
        Donation $donation,
        Subscription $subscription,
        $gatewayData = null
    ): GatewayCommand {
        $subscriptionId = $gatewayData['payPalSubscriptionId'];

        /** @var SubscriptionRepository $payPalSubscriptionRepository */
        $payPalSubscriptionRepository = give(SubscriptionRepository::class);

        $payPalSubscription = $payPalSubscriptionRepository->getFromPayPal($subscriptionId);

        if ($payPalSubscription['status'] === 'ACTIVE') {
            return new SubscriptionProcessing($subscriptionId);
        }

        $payPalSubscriptionRepository->activate($subscriptionId);

        return new SubscriptionProcessing($subscriptionId);
    }

    /**
     * @since 2.5.0
     * @throws PaymentGatewayException
     */
    public function cancelSubscription(Subscription $subscription)
    {
        try {
            // @phpstan-ignore-next-line
            give(SubscriptionRepository::class)
                ->updateStatus($subscription->gatewaySubscriptionId, 'cancel');

            $subscription->status = SubscriptionStatus::CANCELLED();
            $subscription->save();
        } catch (\Exception $exception) {
            throw new PaymentGatewayException(
                sprintf('Unable to cancel subscription with PayPal. %s', $exception->getMessage()),
                $exception->getCode(),
                $exception
            );
        }
    }
}
