<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Mollie\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;
use Give\Subscriptions\Models\Subscription;
use GiveMollie\Actions\GetMollieCustomer;

/**
 * @see https://docs.mollie.com/reference/v2/subscriptions-api/cancel-subscription
 *
 * @since 2.7.0
 */
class CancelMollieSubscription
{
    /**
     * @since 2.7.0
     *
     * @throws PaymentGatewayException
     */
    public function __invoke(Subscription $subscription)
    {
        try {
            $mollieCustomer = (new GetMollieCustomer())($subscription->initialDonation());

            $mollieResponse = $mollieCustomer->cancelSubscription($subscription->gatewaySubscriptionId);

            if ('canceled' !== $mollieResponse->status) {
                PaymentGatewayLog::error(
                    sprintf('[Mollie] Failed to cancel subscription %s.', $subscription->id),
                    [
                        'Payment Gateway' => $subscription->gateway()->getId(),
                        'Subscription' => $subscription->id,
                        'Gateway Subscription Id' => $subscription->gatewaySubscriptionId,
                        'Mollie Response' => $mollieResponse,
                    ]
                );


                throw new PaymentGatewayException(sprintf(
                    __('Mollie API returned an invalid response status: %s', 'give-mollie'),
                    $mollieResponse->status
                ));
            }
        } catch (Exception $e) {
            throw new PaymentGatewayException(
                sprintf(
                    __('[Mollie] Failed to cancel subscription. API Error: %s', 'give-mollie'),
                    $e->getCode() . ' - ' . $e->getMessage()
                )
            );
        }
    }
}
