<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\GoCardless\Webhooks;

use GiveGoCardless\DataTransferObjects\GoCardlessWebhookNotification;
use GiveGoCardless\Gateway\GoCardlessGateway;
use Exception;

/**
 * @since 2.14.0
 */
class GoCardlessSubscriptionWebhookNotificationHandler
{
    /**
     * @since 2.14.0
     *
     * @throws Exception
     */
    public function __invoke(GoCardlessWebhookNotification $notification)
    {
        if ($notification->resourceType === 'subscriptions') {
            $this->handleSubscriptionEvent($notification);
        }
    }

    /**
     * @since 2.14.0
     *
     * @throws Exception
     */
    protected function handleSubscriptionEvent(GoCardlessWebhookNotification $notification)
    {
        $isRecurringDonation = isset($notification->links['subscription']);
        if (!$isRecurringDonation){
            return;
        }

        $gatewaySubscriptionId = $notification->links['subscription'];

        switch ($notification->action) {
            case 'payment_created':
                $gatewayTransactionId = $notification->links['payment'];
                $subscription = give()->subscriptions->getByGatewaySubscriptionId($gatewaySubscriptionId);

                if ($subscription->totalDonations() === 1 && empty($subscription->initialDonation()->gatewayTransactionId)) {
                    GoCardlessGateway::webhook()->events->subscriptionFirstDonation(
                        $gatewayTransactionId,
                        __('Subscription First Donation Updated With Transaction ID.', 'give-recurring'),
                        false,
                        false,
                        $gatewaySubscriptionId
                    );
                } else {
                    GoCardlessGateway::webhook()->events->subscriptionRenewalDonation($gatewaySubscriptionId, $gatewayTransactionId);
                }

                break;
            case 'cancelled':
                GoCardlessGateway::webhook()->events->subscriptionCancelled($gatewaySubscriptionId);
                break;
            case 'finished':
                GoCardlessGateway::webhook()->events->subscriptionCompleted($gatewaySubscriptionId);
                break;
        }
    }
}
