<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\GoCardless\DataTransferObjects;

/**
 * @since 2.14.0
 */
class GoCardlessSubscription
{
    /**
     * @var string
     */
    public $id;

    /**
     * @var string
     */
    public $createdAt;

    /**
     * @var int
     */
    public $amount;

    /**
     * @var string
     */
    public $currency;

    /**
     * @var string
     */
    public $status;

    /**
     * @var string
     */
    public $name;

    /**
     * @var string
     */
    public $startDate;

    /**
     * @var string|null
     */
    public $endDate;

    /**
     * @var int
     */
    public $interval;

    /**
     * @var string
     */
    public $intervalUnit;

    /**
     * @var int|null
     */
    public $dayOfMonth;

    /**
     * @var int|null
     */
    public $month;

    /**
     * @var int|null
     */
    public $count;

    /**
     * @var array
     */
    public $metadata;

    /**
     * @var string|null
     */
    public $paymentReference;

    /**
     * @var array
     */
    public $upcomingPayments;

    /**
     * @var int
     */
    public $appFee;

    /**
     * @var array
     */
    public $links;

    /**
     * @var bool
     */
    public $retryIfPossible;

    /**
     * @var string|null
     */
    public $earliestChargeDateAfterResume;

    /**
     * @var bool
     */
    public $parentPlanPaused;

    /**
     * @since 2.14.0
     */
    public static function fromArray(array $data): self
    {
        $instance = new static();

        $instance->id = $data['id'] ?? '';
        $instance->createdAt = $data['created_at'] ?? '';
        $instance->amount = isset($data['amount']) ? (int)$data['amount'] : 0;
        $instance->currency = $data['currency'] ?? '';
        $instance->status = $data['status'] ?? '';
        $instance->name = $data['name'] ?? '';
        $instance->startDate = $data['start_date'] ?? '';
        $instance->endDate = $data['end_date'] ?? null;
        $instance->interval = isset($data['interval']) ? (int)$data['interval'] : 0;
        $instance->intervalUnit = $data['interval_unit'] ?? '';
        $instance->dayOfMonth = isset($data['day_of_month']) ? (int)$data['day_of_month'] : null;
        $instance->month = isset($data['month']) ? (int)$data['month'] : null;
        $instance->count = isset($data['count']) ? (int)$data['count'] : null;
        $instance->metadata = $data['metadata'] ?? [];
        $instance->paymentReference = $data['payment_reference'] ?? null;
        $instance->upcomingPayments = $data['upcoming_payments'] ?? [];
        $instance->appFee = isset($data['app_fee']) ? (int)$data['app_fee'] : 0;
        $instance->links = $data['links'] ?? [];
        $instance->retryIfPossible = $data['retry_if_possible'] ?? false;
        $instance->earliestChargeDateAfterResume = $data['earliest_charge_date_after_resume'] ?? null;
        $instance->parentPlanPaused = $data['parent_plan_paused'] ?? false;

        return $instance;
    }
}
