<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\GoCardless\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;
use Give\Framework\Support\ValueObjects\Money;
use Give\Subscriptions\Models\Subscription;

/**
 * @since 2.14.0
 */
class UpdateGoCardlessSubscriptionAmount
{
    /**
     * @since 2.14.0
     *
     * @throws PaymentGatewayException
     */
    public function __invoke(Subscription $subscription, Money $newRenewalAmount): bool
    {
        if (empty($subscription->gatewaySubscriptionId)) {
            throw new PaymentGatewayException(
                sprintf(
                    __('Unable to update subscription #%s. Subscription does not have gatewaySubscriptionId.', 'give-gocardless'),
                    $subscription->id
                )
            );
        }

        $updateParams = [
            'amount' => $newRenewalAmount->formatToMinorAmount(),
            'app_fee' => 0,
        ];

        $response = \Give_GoCardless_API::gocardless_update_subscription($subscription->gatewaySubscriptionId, $updateParams);

        if (is_wp_error($response) || isset($response['error'])) {
            throw new PaymentGatewayException(sprintf(
                __('Error to cancel subscription #%s: %s - %s', 'give-gocardless'),
                $subscription->gatewaySubscriptionId,
                isset($response['error']['code']) ? $response['error']['code'] : $response->get_error_code(),
                isset($response['error']['message']) ? $response['error']['message'] : $response->get_error_message()
            ));
        }

        return true;
    }
}
