<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * Class GetProduct
 *
 * This class uses as request to get a product.
 *
 * @since 2.6.0
 */
class GetProduct extends HttpRequest
{
    /**
     * CreatePlan constructor.
     *
     * @since 2.6.0
     */
    public function __construct(array $headers, string $productId )
    {
        $endpoint = "/v1/catalogs/products/$productId";
        parent::__construct($endpoint, 'GET');

        $this->headers = array_merge($this->headers, $headers);
    }
}
