<?php

namespace GiveRecurring\PaymentGateways\PayPalCommerce\PayPalHttpRequests;

use PayPalHttp\HttpRequest;

/**
 * Class CreateSubscription
 *
 * This class uses as request to create a subscription.
 *
 * @since 2.6.0
 */
class CreateSubscription extends HttpRequest
{
    /**
     * CreateSubscription constructor.
     *
     * @since 2.6.0
     */
    public function __construct(array $headers, array $requestBody)
    {
        parent::__construct('/v1/billing/subscriptions', 'POST');

        $this->headers = array_merge($this->headers, $headers);
        $this->body = wp_json_encode($requestBody);
    }
}
