<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Braintree\ValueObjects;

use Braintree\Subscription;
use Give\Framework\Support\ValueObjects\Enum;

/**
 * @see https://developer.paypal.com/braintree/docs/reference/response/subscription/php#status
 *
 * @since 2.8.0
 *
 * @method static BraintreeSubscriptionStatus ACTIVE()
 * @method static BraintreeSubscriptionStatus CANCELED()
 * @method static BraintreeSubscriptionStatus EXPIRED()
 * @method static BraintreeSubscriptionStatus PAST_DUE()
 * @method static BraintreeSubscriptionStatus PENDING()
 * @method bool isActive()
 * @method bool isCanceled()
 * @method bool isExpired()
 * @method bool isPastDue()
 * @method bool isPending()
 */
class BraintreeSubscriptionStatus extends Enum
{
    /**
     * @see https://developer.paypal.com/braintree/docs/guides/recurring-billing/overview#active
     */
    const ACTIVE = Subscription::ACTIVE;

    /**
     * @see https://developer.paypal.com/braintree/docs/guides/recurring-billing/overview#canceled
     */
    const CANCELED = Subscription::CANCELED;

    /**
     * @see https://developer.paypal.com/braintree/docs/guides/recurring-billing/overview#expired
     */
    const EXPIRED = Subscription::EXPIRED;

    /**
     * @see https://developer.paypal.com/braintree/docs/guides/recurring-billing/overview#past-due
     */
    const PAST_DUE = Subscription::PAST_DUE;

    /**
     * @see https://developer.paypal.com/braintree/docs/guides/recurring-billing/overview#pending
     */
    const PENDING = Subscription::PENDING;
}

