<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Braintree\DataTransferObjects;

use GiveRecurring\PaymentGatewayModules\Modules\Braintree\ValueObjects\BraintreeSubscriptionStatus;

/**
 * @since 2.8.0
 */
class BraintreeSubscription
{
    /**
     * @var string
     */
    public $transactionId;

    /**
     * @var string
     */
    public $id;

    /**
     * @var BraintreeSubscriptionStatus
     */
    public $status;

    /**
     * @since 2.8.0
     */
    public static function fromArray(array $data): BraintreeSubscription
    {
        $instance = new static();

        $instance->transactionId = $data['transactionId'] ?? 'transactionId';
        $instance->id = $data['id'] ?? '';
        $instance->status = ! empty($data['status']) ? new BraintreeSubscriptionStatus($data['status']) : null;

        return $instance;
    }
}
