<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Braintree\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Subscriptions\Models\Subscription;
use GiveBraintree\API\BraintreeApi;
use GiveBraintree\API\BraintreeApiFacade;

/**
 * @since 2.8.0
 */
class CancelBraintreeSubscription
{
    /**
     * @var BraintreeApiFacade
     */
    private $braintreeApi;

    /**
     * @since 2.8.0
     */
    public function __construct(BraintreeApiFacade $braintreeApi)
    {
        $this->braintreeApi = $braintreeApi;
    }

    /**
     * @since 2.8.0
     *
     * @throws Exception
     */
    public function __invoke(Subscription $subscription): bool
    {
        /**
         * @see https://developer.paypal.com/braintree/docs/reference/request/subscription/cancel/php
         */
        $result = $this->braintreeApi->cancelSubscription($subscription->gatewaySubscriptionId);

        if ( ! $result->success) {
            BraintreeApi::logResultErrors($result, $subscription->initialDonation(), 'Unable to cancel Subscription');

            throw new PaymentGatewayException(__('There was a problem canceling the Subscription.',
                'give-braintree'));
        }

        return true;
    }
}
