<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Paystack\DataTransferObjects;

/**
 * @since 2.16.0
 */
class PaystackPlan
{
    public int $id;
    public string $planCode;
    public string $name;
    public int $amount;
    public string $interval;
    public string $currency;
    public ?int $invoiceLimit;

    /**
     * @since 2.16.0
     */
    public function __construct(array $data)
    {
        $this->id = (int)$data['id'] ?? 0;
        $this->planCode = $data['plan_code'] ?? '';
        $this->name = $data['name'] ?? '';
        $this->amount = $data['amount'] ?? 0;
        $this->interval = $data['interval'] ?? '';
        $this->currency = $data['currency'] ?? '';
        $this->invoiceLimit = $data['invoice_limit'] ?? null;
    }

    /**
     * Create a PaystackPlan from an array
     *
     * @since 2.16.0
     */
    public static function fromArray(array $data): self
    {
        return new self($data);
    }

    /**
     * Convert to array
     *
     * @since 2.16.0
     */
    public function toArray(): array
    {
        return [
            'plan_code' => $this->planCode,
            'name' => $this->name,
            'amount' => $this->amount,
            'interval' => $this->interval,
            'currency' => $this->currency,
            'invoice_limit' => $this->invoiceLimit,
        ];
    }
}
