<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Blink\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Subscriptions\Models\Subscription;
use GiveBlink\API\BlinkApi;
use GiveBlink\DataTransferObjects\GatewayDataDTO;

/**
 * @since 2.11.0
 */
class UpdateBlinkSubscription
{
    /**
     * @since 2.11.0
     *
     * @throws PaymentGatewayException;
     */
    public function __invoke(Subscription $subscription, GatewayDataDTO $gatewayData): array
    {
        try {
            $paymentData = $this->buildSubscriptionData($gatewayData);

            return BlinkApi::client()->updateRepeatPaymentCreditCard(
                $subscription->gatewaySubscriptionId,
                $paymentData
            );
        } catch (Exception $e) {
            throw new PaymentGatewayException(
                sprintf(
                    __('[Blink] Failed to update the subscription. API Error: %s', 'give-blink'),
                    $e->getCode() . ' - ' . $e->getMessage()
                )
            );
        }
    }

    /**
     * Build the data array for updating.
     *
     * @since 2.11.0
     */
    private function buildSubscriptionData(
        GatewayDataDTO $gatewayData
    ): array {
        return [
            'payment_type' => 'fixed_schedule',
            'paymentToken' => $gatewayData->paymentMethodData['paymentDetails']['paymentToken'],
        ];
    }
}
