<?php

namespace GiveRecurring\PaymentGatewayModules\Modules\Blink\Actions;

use Exception;
use Give\Framework\PaymentGateways\Exceptions\PaymentGatewayException;
use Give\Framework\PaymentGateways\Log\PaymentGatewayLog;
use Give\Subscriptions\Models\Subscription;
use GiveBlink\API\BlinkApi;

/**
 * @since 2.11.0
 */
class CancelBlinkSubscription
{
    /**
     * @since 2.11.0
     *
     * @throws PaymentGatewayException
     */
    public function __invoke(Subscription $subscription)
    {
        try {
            $response = BlinkApi::client()->cancelRepeatPayment($subscription->gatewaySubscriptionId);

            if (false === $response['success']) {
                PaymentGatewayLog::error(
                    sprintf('[Blink] Failed to cancel subscription %s.', $subscription->id),
                    [
                        'Payment Gateway' => $subscription->gateway()->getId(),
                        'Subscription' => $subscription->id,
                        'Gateway Subscription Id' => $subscription->gatewaySubscriptionId,
                        'Blink Response' => $response,
                    ]
                );


                throw new PaymentGatewayException(
                    sprintf(
                        __('Blink API returned an invalid response status: %s', 'give-blink'),
                        $response['message']
                    )
                );
            }
        } catch (Exception $e) {
            throw new PaymentGatewayException(
                sprintf(
                    __('[Blink] Failed to cancel subscription. API Error: %s', 'give-blink'),
                    $e->getCode() . ' - ' . $e->getMessage()
                )
            );
        }
    }
}
