<?php

namespace GiveFeeRecovery\ValueObjects;

use Give\Framework\Support\ValueObjects\Enum;

/**
 * @since 1.10.0
 *
 * @method static FeeStatus ACCEPTED()
 * @method static FeeStatus REJECTED()
 * @method static FeeStatus DISABLED()
 * @method bool isRejected()
 * @method bool isDisabled()
 */
class FeeStatus extends Enum
{
    const ACCEPTED = 'accepted';
    const REJECTED = 'rejected';
    const DISABLED = 'disabled';

    /**
     * @since 1.10.0
     *
     * @return array
     */
    public static function labels(): array
    {
        return [
            self::ACCEPTED => __('Accepted', 'give'),
            self::REJECTED => __('Rejected', 'give'),
            self::DISABLED => __('Disabled', 'give'),
        ];
    }

    /**
     * @since 1.10.0
     *
     * @return string
     */
    public function label(): string
    {
        return self::labels()[$this->getValue()];
    }
}
