<?php

namespace GiveFeeRecovery;

use Exception;
use Give\Helpers\Hooks;
use GiveFeeRecovery\Admin\ListTable\ListTable;
use GiveFeeRecovery\FormExtension\DonationForm\Actions\AddFeeRecoveryConfirmation;
use GiveFeeRecovery\FormExtension\Hooks\DonationFormBlockRender;
use GiveFeeRecovery\FormExtension\Hooks\DonationFormScriptsEnqueue;
use GiveFeeRecovery\FormExtension\Hooks\FormBuilderScriptsEnqueue;
use GiveFeeRecovery\FormExtension\Hooks\NewFormDefaultBlocks;
use GiveFeeRecovery\FormExtension\Repositories\FeeRecoverySettings;
use GiveFeeRecovery\Service\AddFeeToDonationAmount;

/**
 * Class ServiceProvider
 * @package GiveFeeRecovery
 * @since 1.9.1
 */
class ServiceProvider implements \Give\ServiceProviders\ServiceProvider
{
    /**
     * @inheritDoc
     * @since 1.9.1
     */
    public function register()
    {
        give()->singleton(FeeRecoverySettings::class);
    }

    /**
     * @inheritDoc
     *
     * @since 2.3.1 Added actions AddFeeRecoveryConfirmation
     * @since 2.0 Register Form Extension
     * @since 1.9.1
     * @throws Exception
     */
    public function boot()
    {
        Hooks::addFilter('give_donation_total', AddFeeToDonationAmount::class);

        // Register List Table Columns
        Hooks::addFilter('givewp_donations_list_table', ListTable::class, 'registerDonationsListTableColumns');

        // Form Extension hooks
        Hooks::addAction('givewp_form_builder_new_form', NewFormDefaultBlocks::class);
        Hooks::addAction('givewp_form_builder_enqueue_scripts', FormBuilderScriptsEnqueue::class);
        Hooks::addAction('givewp_donation_form_enqueue_scripts', DonationFormScriptsEnqueue::class);
        Hooks::addFilter(
            'givewp_donation_form_block_render_givewp-fee-recovery/fee-recovery',
            DonationFormBlockRender::class,
            '__invoke',
            10,
            4
        );

        Hooks::addAction('givewp_donation_form_schema', AddFeeRecoveryConfirmation::class, '__invoke', 10, 2);
    }
}
