<?php

namespace GiveFeeRecovery\FormExtension\Repositories;

class FeeRecoverySettings
{
    /**
     * @since 2.1.1
     */
    public function isFeeRecoveryEnabled(): bool
    {
        return give_get_option('give_fee_recovery', 'disabled') === 'enabled';
    }
    /**
     * @since 2.1.1
     */
    public function getDonorOptIn(): bool
    {
        return give_get_option('give_fee_mode', 'donor_opt_in') === 'donor_opt_in';
    }

    /**
     * @since 2.1.1
     */
    public function getFeeCheckboxLabel(): string
    {
        return give_get_option(
            'give_fee_checkbox_label',
            __(
                'I\'d like to help cover the transaction fees of {fee_amount} for my donation.',
                'give-fee-recovery'
            )
        );
    }

    /**
     * @since 2.1.1
     */
    public function getFeeMessage(): string
    {
        return give_get_option(
            'give_fee_explanation',
            __('Plus an additional {fee_amount} to cover gateway fees.', 'give-fee-recovery')
        );
    }

    /**
     * @since 2.1.1
     */
    public function getFeeSupportForAllGateways(): bool
    {
        return give_get_option('give_fee_configuration', 'all_gateways') === 'all_gateways';
    }

    /**
     * @since 2.1.1
     */
    public function getFeePercentage(): float
    {
        return (float)give_get_option('give_fee_percentage', give_fee_get_default_percentage());
    }

    /**
     * @since 2.1.1
     */
    public function getFeeBaseAmount(): float
    {
        return (float)give_get_option(
            'give_fee_base_amount',
            give_fee_get_default_additional_amount()
        );
    }

    /**
     * @since 2.1.1
     */
    public function getFeeMaxAmount(): float
    {
        return (float)give_get_option(
            'give_fee_maximum_fee_amount',
            give_format_decimal(['amount' => '0.00'])
        );
    }

    /**
     * @since 2.1.1
     */
    public function getIncludeFeeBreakdown(): bool
    {
        return give_get_option('give_fee_breakdown', 'enabled') === 'enabled';
    }
}