<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

use Exception;
use Give\Framework\Support\ValueObjects\Money;
use Give\Subscriptions\Models\Subscription;

/**
 * @since 2.0
 */
class UpdateSubscriptionWithFeeAmountRecovered
{
    /**
     * Update Subscription model with feeAmountRecovered
     *
     * @throws Exception
     */
    public function __invoke(string $value, Subscription $subscription)
    {
        $subscription->feeAmountRecovered = Money::fromDecimal(
            $value,
            $subscription->amount->getCurrency()
        );

        $subscription->amount = $subscription->amount->add($subscription->feeAmountRecovered);

        $subscription->save();
    }
}
