<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

use Exception;
use Give\Donations\Models\Donation;
use Give\Framework\Support\ValueObjects\Money;

/**
 * @since 2.0
 */
class UpdateDonationWithFeeAmountRecovered
{
    /**
     * Update Donation model with feeAmountRecovered
     *
     * @throws Exception
     */
    public function __invoke(string $value, Donation $donation)
    {
        $donation->feeAmountRecovered = Money::fromDecimal(
            $value,
            $donation->amount->getCurrency()
        );

        give()->payment_meta->update_meta(
            $donation->id,
            '_give_fee_donation_amount',
            give_sanitize_amount_for_db(
                $donation->amount->formatToDecimal(),
                ['currency' => $donation->amount->getCurrency()]
            )
        );

        $donation->amount = $donation->amount->add($donation->feeAmountRecovered);

        $donation->save();
    }
}
