<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

use Give\DonationForms\Models\DonationForm;
use Give\Framework\Blocks\BlockModel;
use GiveFeeRecovery\FormExtension\Repositories\FeeRecoverySettings;

/**
 * Class NewFormDefaultBlocks
 *
 * @since 2.0
 */
class NewFormDefaultBlocks
{
    /**
     * @var FeeRecoverySettings
     */
    public $settings;

    /**
     * @since 2.1.1
     */
    public function __construct(FeeRecoverySettings $settings)
    {
        $this->settings = $settings;
    }

    /**
     * Add the fee recovery block to the default blocks for new forms.
     */
    public function __invoke(DonationForm $form)
    {
        if (!$this->settings->isFeeRecoveryEnabled()) {
            return;
        }

        $block = BlockModel::make([
            'name' => 'givewp-fee-recovery/fee-recovery',
            'attributes' => [
                'useGlobalSettings' => true,
                'feeSupportForAllGateways' => $this->settings->getFeeSupportForAllGateways(),
                'perGatewaySettings' => [],
                'feePercentage' => $this->settings->getFeePercentage(),
                'feeBaseAmount' => $this->settings->getFeeBaseAmount(),
                'maxFeeAmount' => $this->settings->getFeeMaxAmount(),
                'includeInDonationSummary' => $this->settings->getIncludeFeeBreakdown(),
                'donorOptIn' => $this->settings->getDonorOptIn(),
                'feeCheckboxLabel' => $this->settings->getFeeCheckboxLabel(),
                'feeMessage' => $this->settings->getFeeMessage(),
            ]
        ]);

        $form->blocks->insertAfter('givewp/donation-amount', $block);
    }
}
