<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

use Give\Framework\PaymentGateways\PaymentGateway;
use Give\Framework\PaymentGateways\PaymentGatewayRegister;
use GiveFeeRecovery\FormExtension\Repositories\FeeRecoverySettings;

/**
 * Class FormBuilderScriptsEnqueue
 *
 * @since 2.0
 */
class FormBuilderScriptsEnqueue
{
    /**
     * @var FeeRecoverySettings
     */
    public $settings;

    /**
     * @since 2.1.1
     */
    public function __construct(FeeRecoverySettings $settings)
    {
        $this->settings = $settings;
    }

    /**
     * Enqueues the fee recovery form builder extension scripts and styles.
     *
     * @return void
     */
    public function __invoke()
    {
        $scriptAsset = require GIVE_FEE_RECOVERY_PLUGIN_DIR . '/build/feeRecoveryFormBuilderExtension.asset.php';

        wp_enqueue_script(
            'givewp-form-extension-fee-recovery',
            GIVE_FEE_RECOVERY_PLUGIN_URL . 'build/feeRecoveryFormBuilderExtension.js',
            $scriptAsset['dependencies'],
            false,
            true
        );

        wp_localize_script(
            'givewp-form-extension-fee-recovery',
            'feeRecoveryBlockSettings',
            [
                'currency' => give_get_currency(),
                'donorOptIn' => $this->settings->getDonorOptIn(),
                'feeCheckboxLabel' => $this->settings->getFeeCheckboxLabel(),
                'feeMessage' => $this->settings->getFeeMessage(),
                'gateways' => $this->getGateways(),
            ]
        );

        wp_enqueue_style(
            'givewp-form-extension-fee-recovery',
            GIVE_FEE_RECOVERY_PLUGIN_URL . 'build/feeRecoveryFormBuilderExtension.css'
        );
    }

    /**
     * @since 2.1.0
     */
    public function getGateways(): array
    {
        $enabledGateways = array_keys(give_get_option('gateways_v3', []));

        $builderPaymentGatewayData = array_map(static function ($gatewayClass) use ($enabledGateways) {
            /** @var PaymentGateway $gateway */
            $gateway = give($gatewayClass);

            return [
                'id' => $gateway::id(),
                'enabled' => in_array($gateway::id(), $enabledGateways, true),
                'label' => give_get_gateway_checkout_label($gateway::id()) ?? $gateway->getPaymentMethodLabel(),
                'supportsSubscriptions' => $gateway->supportsSubscriptions(),
            ];
        }, give(PaymentGatewayRegister::class)->getPaymentGateways(3));

        return array_values($builderPaymentGatewayData);
    }
}
