<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

/**
 * Class DonationFormScriptsEnqueue
 *
 * @since 2.0
 */
class DonationFormScriptsEnqueue
{
    /**
     * Enqueues the fee recovery donation form extension scripts and styles.
     *
     * @return void
     */
    public function __invoke()
    {
        $scriptAsset = require GIVE_FEE_RECOVERY_PLUGIN_DIR . '/build/feeRecoveryDonationFormExtension.asset.php';

        wp_enqueue_script(
            'givewp-form-extension-fee-recovery',
            GIVE_FEE_RECOVERY_PLUGIN_URL . 'build/feeRecoveryDonationFormExtension.js',
            $scriptAsset['dependencies'],
            false,
            true
        );

        wp_enqueue_style(
            'givewp-form-extension-fee-recovery',
            GIVE_FEE_RECOVERY_PLUGIN_URL . 'build/feeRecoveryDonationFormExtension.css'
        );
    }
}
