<?php

namespace GiveFeeRecovery\FormExtension\Hooks;

use Give\Framework\Blocks\BlockModel;
use Give\Framework\FieldsAPI\Contracts\Node;
use Give\Framework\FieldsAPI\Exceptions\EmptyNameException;
use GiveFeeRecovery\FormExtension\DonationForm\Actions\ConvertFeeRecoveryBlockToFieldsApi;
use GiveFeeRecovery\FormExtension\DonationForm\Fields\FeeRecovery;

/**
 * Class DonationFormBlockRender
 *
 * @since 2.0
 */
class DonationFormBlockRender
{
    /**
     * Renders the fee recovery field for the donation form block.
     *
     * @param  Node|null  $node The node instance.
     * @param BlockModel $block The block model instance.
     * @param int $blockIndex The index of the block.
     *
     * @return FeeRecovery The fee recovery field instance.
     * @throws EmptyNameException
     */
    public function __invoke(?Node $node, BlockModel $block, int $blockIndex, int $formId): FeeRecovery
    {
        return (new ConvertFeeRecoveryBlockToFieldsApi())($block, $formId);
    }
}
