import {CurrencyCode} from '@givewp/form-builder-library/build/CurrencyControl/CurrencyCode';

/**
 * @since 2.2.0
 */
interface FeeRecoveryBlockSettings {
  currency: CurrencyCode;
  donorOptIn: boolean;
  feeCheckboxLabel: string;
  feeMessage: string;
  gateways: [];
}

/**
 * @since 2.2.0
 */
declare const window: {
    feeRecoveryBlockSettings: FeeRecoveryBlockSettings;
} & Window;

/**
 * @since 2.2.0
 */
export default function getWindowData() {
    return window.feeRecoveryBlockSettings;
}
