import type {BlockConfiguration} from '@wordpress/blocks';
import {__} from '@wordpress/i18n';

const metadata: BlockConfiguration = {
    name: 'givewp-fee-recovery/fee-recovery',
    title: __('Fee Recovery', 'give-fee-recovery'),
    description: __('Donors can opt in to add an extra fee to cover the cost of processing.', 'give-fee-recovery'),
    category: 'addons',
    supports: {
        multiple: false,
    },
    attributes: {
        useGlobalSettings: {
            type: 'boolean',
            default: true,
        },
        feeSupportForAllGateways: {
            type: 'boolean',
            default: true,
        },
        perGatewaySettings: {
            type: 'object',
            default: {},
        },
        feePercentage: {
            type: 'number',
            default: 2.9,
        },
        feeBaseAmount: {
            type: 'number',
            default: 0.3,
        },
        maxFeeAmount: {
            type: 'number',
        },
        includeInDonationSummary: {
            type: 'boolean',
            default: true,
        },
        donorOptIn: {
            type: 'boolean',
            default: true,
        },
        feeCheckboxLabel: {
            type: 'string',
            default: __(
                "I'd like to help cover the transaction fees of {fee_amount} for my donation.",
                'give-fee-recovery'
            ),
        },
        feeMessage: {
            type: 'string',
            default: __('Plus an additional {fee_amount} to cover gateway fees.', 'give-fee-recovery'),
        },
        defaultDonorOptIn: {
            type: 'boolean',
            default: false,
        }
    },
};

export default metadata;
