import {useEffect} from '@wordpress/element';

export default function useGatewayDefaultSettingsEffect(gateways, perGatewaySettings, setAttributes) {
    useEffect(() => {
        const defaultSettings = gateways.reduce((acc, gateway) => {
            if (!perGatewaySettings.hasOwnProperty(gateway.id)) {
                acc[gateway.id] = {
                    enabled: true,
                    feePercentage: 2.9,
                    feeBaseAmount: 0.3,
                    maxFeeAmount: null,
                };
            }
            return acc;
        }, {});

        setAttributes({
            perGatewaySettings: {
                ...perGatewaySettings,
                ...defaultSettings,
            },
        });
    }, []);
}
