import {RadioControl} from '@wordpress/components';
import {__} from '@wordpress/i18n';

import FeeInputs from '../fee-inputs';

export default function GatewaySettings({settings, updateSetting}) {
    return (
        <>
            <div className={'tabHeader'}>
                <h2>{__('Fee recovery', 'give-fee-recovery')}</h2>
                <p>{__('Enable this to configure fee recovery for this Gateway.', 'give-fee-recovery')}</p>
            </div>
            <RadioControl
                className={'radioControl'}
                label={__('Enabled/Disabled', 'give-fee-recovery')}
                hideLabelFromVision={true}
                selected={settings.enabled.toString()}
                options={[
                    {label: __('Enabled', 'give-fee-recovery'), value: 'true'},
                    {label: __('Disabled', 'give-fee-recovery'), value: 'false'},
                ]}
                onChange={(value) => updateSetting('enabled', JSON.parse(value))}
            />

            {settings.enabled && (
                <div className={'fields'}>
                    <FeeInputs
                        feePercentage={settings.feePercentage}
                        feeBaseAmount={settings.feeBaseAmount}
                        maxFeeAmount={settings.maxFeeAmount}
                        updateSetting={updateSetting}
                    />
                </div>
            )}
        </>
    );
}
