import {__} from '@wordpress/i18n';
import {CurrencyControl} from '@givewp/form-builder-library';
import getWindowData from '../../utilities/getWindowData';

export default function FeeInputs({feePercentage, feeBaseAmount, maxFeeAmount, updateSetting}) {
    const {currency} = getWindowData();

    return (
        <>
            <CurrencyControl
                label={__('Fee Percentage', 'give-fee-recovery')}
                help={__('This is typically between 1.5-3.5% depending on the gateway.', 'give-fee-recovery')}
                value={feePercentage}
                onValueChange={(value) => updateSetting('feePercentage', value)}
                decimalScale={1}
                maxLength={4}
                suffix="%"
                intlConfig={{locale: window.navigator.language}}
                currency={currency}
            />
            <CurrencyControl
                label={__('Additional Fee Amount', 'give-fee-recovery')}
                value={feeBaseAmount}
                onValueChange={(value) => updateSetting('feeBaseAmount', value)}
                help={__(
                    'This is an additional amount added to the percentage fee. Example, 2.9% + 30 cents.',
                    'give-fee-recovery'
                )}
                currency={currency}
            />
            <CurrencyControl
                label={__('Maximum Fee Amount', 'give-fee-recovery')}
                value={maxFeeAmount}
                onValueChange={(value) => updateSetting('maxFeeAmount', value)}
                help={__(
                    'Limit the fee amount for the donors for more than a specific fee amount. For example, 2.9% + 30 cents but not more than $12.50. To remove the Maximum Fee Amount leave the field empty.',
                    'give-fee-recovery'
                )}
                currency={currency}
            />
        </>
    );
}


declare const window: {
    givewp: {
        form: {
            components: {
                CurrencyControl?: any;
            };
        };
    };
    navigator: {
        language: string;
    };
} & Window;
