import BlockInspectorControls from './inspector-controls';
import BlockPlaceholder from './block-placeholder';
import type {BlockEditProps} from '@wordpress/blocks';

declare const window: {
    feeRecoveryBlockSettings: {
        donorOptIn: boolean;
        feeCheckboxLabel: string;
        feeMessage: string;
    };
} & Window;

export default function Edit(props: BlockEditProps<any>) {
    const {attributes} = props;
    const {useGlobalSettings} = attributes;
    let {donorOptIn, feeCheckboxLabel, feeMessage, defaultDonorOptIn} = attributes;

    if (useGlobalSettings) {
        ({donorOptIn, feeCheckboxLabel, feeMessage} = window.feeRecoveryBlockSettings);
        defaultDonorOptIn = false;
    }

    return (
        <>
            <BlockInspectorControls {...props} />
            <BlockPlaceholder donorOptIn={donorOptIn} feeCheckboxLabel={feeCheckboxLabel} feeMessage={feeMessage} defaultDonorOptIn={defaultDonorOptIn} />
        </>
    );
}
