import {CheckboxControl} from '@wordpress/components';

type BlockPlaceholderProps = {
    donorOptIn: boolean;
    feeCheckboxLabel: string;
    feeMessage: string;
    defaultDonorOptIn: boolean;
}

export default function BlockPlaceholder({donorOptIn, feeCheckboxLabel, feeMessage, defaultDonorOptIn}: BlockPlaceholderProps) {
    return (
        <div className={'feeRecovery-container'}>
            {donorOptIn ? (
                <CheckboxControl label={feeCheckboxLabel} onChange={null} disabled={true} checked={defaultDonorOptIn} />
            ) : (
                <span className={'label'}>{feeMessage}</span>
            )}
        </div>
    );
}
