import {PropTypes} from './FeeRecovery';
import type {GiveWP} from './types/window';

interface FeeRecoveryConfirmationFieldPropTypes extends PropTypes {
    hide?: boolean;
}

declare const window: GiveWP & Window;

/**
 * This component is used to display the fee recovery confirmation field next to the gateway options.
 * This is necessary in multiStep enabled form layouts and per-gateway settings where the gateway settings alter the original fee amount.
 *
 * This component is just a wrapper around the FeeRecovery component that persists the checked state of the fee recovery checkbox.
 *
 * @since 2.3.1
 */
export default function FeeRecoveryConfirmationField(props: FeeRecoveryConfirmationFieldPropTypes) {
    const FeeRecovery = window.givewp.form.templates.fields.feeRecovery;
    const { useWatch } = window.givewp.form.hooks;
    const feeRecovery = useWatch({ name: 'feeRecovery' });

    if (feeRecovery > 0) {
        props.defaultDonorOptIn = true;
    }

    if (props?.hide){
        return <div className="givewp-fields-feeRecoveryConfirmation--hide">
            <FeeRecovery {...props} />
        </div>
    }

    return <FeeRecovery {...props} />;
}
