<?php

namespace GiveFeeRecovery\FormExtension\DonationForm\Fields;

use Give\Framework\FieldsAPI\Exceptions\EmptyNameException;
use Give\Framework\FieldsAPI\Field;

class FeeRecovery extends Field
{
    protected $donorOptIn;
    protected $feeBaseAmount;
    protected $feeCheckboxLabel;
    protected $feeMessage;
    protected $feePercentage;
    protected $feeSupportForAllGateways;
    protected $includeInDonationSummary;
    protected $maxFeeAmount;
    protected $perGatewaySettings = [];
    protected $useGlobalSettings;
    protected $defaultDonorOptIn;

    const TYPE = 'feeRecovery';

    /**
     * @since 2.0
     */
    public function getDonorOptIn(): bool
    {
        return $this->donorOptIn;
    }

    /**
     * @since 2.0
     */
    public function donorOptIn(bool $donorOptIn): FeeRecovery
    {
        $this->donorOptIn = $donorOptIn;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getFeeBaseAmount(): float
    {
        return $this->feeBaseAmount;
    }

    /**
     * @since 2.0
     */
    public function feeBaseAmount(float $feeBaseAmount): FeeRecovery
    {
        $this->feeBaseAmount = $feeBaseAmount;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getFeeCheckboxLabel(): string
    {
        return $this->feeCheckboxLabel;
    }

    /**
     * @since 2.0
     */
    public function feeCheckboxLabel(string $feeCheckboxLabel): FeeRecovery
    {
        $this->feeCheckboxLabel = $feeCheckboxLabel;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getFeeMessage(): string
    {
        return $this->feeMessage;
    }

    /**
     * @since 2.0
     */
    public function feeMessage(string $feeMessage): FeeRecovery
    {
        $this->feeMessage = $feeMessage;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getFeePercentage(): float
    {
        return $this->feePercentage;
    }

    /**
     * @since 2.0
     */
    public function feePercentage(float $feePercentage): FeeRecovery
    {
        $this->feePercentage = $feePercentage;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getFeeSupportForAllGateways(): bool
    {
        return $this->feeSupportForAllGateways;
    }

    /**
     * @since 2.0
     */
    public function feeSupportForAllGateways(bool $feeSupportForAllGateways): FeeRecovery
    {
        $this->feeSupportForAllGateways = $feeSupportForAllGateways;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getIncludeInDonationSummary(): bool
    {
        return $this->includeInDonationSummary;
    }

    /**
     * @since 2.0
     */
    public function includeInDonationSummary(bool $includeInDonationSummary): FeeRecovery
    {
        $this->includeInDonationSummary = $includeInDonationSummary;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getMaxFeeAmount(): float
    {
        return $this->maxFeeAmount;
    }

    /**
     * @since 2.0
     */
    public function maxFeeAmount(float $maxFeeAmount): FeeRecovery
    {
        $this->maxFeeAmount = $maxFeeAmount;
        return $this;
    }

    /**
     * @since 2.0
     */
    public function getPerGatewaySettings(): array
    {
        return $this->perGatewaySettings;
    }

    /**
     * @since 2.1.2 remove option to set all array values at once
     * @since 2.0
     *
     * @param array{
     *     enabled: bool,
     *     feePercentage: float,
     *     feeBaseAmount: float,
     *     maxFeeAmount: float
     * } $settings
     */
    public function perGatewaySettings(string $gatewayId, array $settings): FeeRecovery
    {
        $this->perGatewaySettings[$gatewayId] = $settings;

        return $this;
    }

    /**
     * @since 2.0
     */
    public function getUseGlobalSettings(): bool
    {
        return $this->useGlobalSettings;
    }

    /**
     * @since 2.0
     */
    public function useGlobalSettings(bool $useGlobalSettings): FeeRecovery
    {
        $this->useGlobalSettings = $useGlobalSettings;
        return $this;
    }

    /**
     * @since 2.3.0
     */
    public function defaultDonorOptIn(bool $defaultDonorOptIn): FeeRecovery
    {
        $this->defaultDonorOptIn = $defaultDonorOptIn;

        return $this;
    }

    /**
     * @since 2.3.1
     * @throws EmptyNameException
     */
    public function toFeeRecoveryConfirmation(string $name = 'feeRecoveryConfirmation')
    {
        $feeRecoveryConfirmation =  FeeRecoveryConfirmation::make($name);

        $properties = array_filter(get_object_vars($this), static function($key) {
            return !in_array($key, ['name', 'scope',]);
        }, ARRAY_FILTER_USE_KEY);

        foreach($properties as $key => $value) {
            $feeRecoveryConfirmation->{$key} = $value;
        }

        $feeRecoveryConfirmation
            ->scope('feeRecoveryConfirmation')
            ->showInAdmin(false)
            ->showInReceipt(false);


        if (apply_filters('givewp_fee_recovery_hide_fee_recovery_confirmation', false)) {
            $feeRecoveryConfirmation->hide();
        }

        return $feeRecoveryConfirmation;
    }
}
