<?php

namespace GiveFeeRecovery\Admin\ListTable;

use Give\Donations\ListTable\DonationsListTable;
use GiveFeeRecovery\Admin\ListTable\Columns\FeeColumn;

/**
 * @since 1.10.0
 */
class ListTable
{

    /**
     * @since 1.10.0
     *
     * @param  DonationsListTable  $listTable
     *
     * @return DonationsListTable
     */
    public static function registerDonationsListTableColumns(DonationsListTable $listTable): DonationsListTable
    {
        $listTable
            ->addColumnBefore('status', new FeeColumn())
            ->setColumnVisibility(FeeColumn::getId(), true);

        return $listTable;
    }
}
