<?php

namespace GiveFeeRecovery\Admin\ListTable\Columns;

use Give\Donations\Models\Donation;
use Give\Framework\ListTable\ModelColumn;
use GiveFeeRecovery\ValueObjects\FeeStatus;

/**
 * @since 1.10.0
 *
 * @extends ModelColumn<Donation>
 */
class FeeColumn extends ModelColumn
{

    /**
     * @since 1.10.0
     *
     * @inheritDoc
     */
    public static function getId(): string
    {
        return 'fee';
    }

    /**
     * @since 1.10.0
     *
     * @inheritDoc
     */
    public function getLabel(): string
    {
        return __('Fee', 'give-fee-recovery');
    }

    /**
     * @since 1.10.0
     *
     * @inheritDoc
     *
     * @param  Donation  $model
     */
    public function getCellValue($model, $locale = ''): string
    {
        if ( ! $model->feeAmountRecovered) {
            $feeStatus = give_get_meta($model->id, '_give_fee_status', true);

            return $feeStatus ? (new FeeStatus($feeStatus))->label() : FeeStatus::DISABLED()->label();
        }

        return sprintf(
            '<div class="fee-amount"><span>%s</span></div>',
            $model->feeAmountRecovered->formatToLocale($locale)
        );
    }
}
