const mix = require('laravel-mix');
const WebpackRTLPlugin = require('webpack-rtl-plugin');

mix
  .setPublicPath('assets/dist')
  .sourceMaps(false)

  .copyDirectory('assets/src/images', 'assets/dist/images')

  .sass('assets/src/css/admin/give-annual-receipts.scss', 'assets/dist/css/give-annual-receipts-admin.css')
  .sass('assets/src/css/frontend/give-annual-receipts.scss', 'assets/dist/css/give-annual-receipts.css')

  .js('assets/src/js/admin/give-annual-receipts-admin.js', 'assets/dist/js/give-annual-receipts-admin.js')
  .js('assets/src/js/frontend/give-annual-receipts.js', 'assets/dist/js/give-annual-receipts.js')

mix.webpackConfig({
  externals: {
    $: 'jQuery',
    jquery: 'jQuery'
  }
});

if (mix.inProduction()) {
    mix.webpackConfig((webpack, config) => {
        return {
            plugins: [
                new WebpackRTLPlugin({
                    suffix: '-rtl',
                    minify: true,
                }),
                ...config.plugins,
            ],
        };
    });
}